#!/bin/bash
# ------------------------------------------------------------------------------
#	Shell script file
#
#  	Copyright(©)   Revvity Cellular Technologies Germany GmbH 2021
#
#  	Description: Create virtual environment on target system
#
#		Examples:	install.sh pyrunner-4.0.23.34-py2.py3-none-any.whl
#					
#		Remark: Version 1.0.0.21154
#
# 		Last change: 
#
#
#    $Date: 2020-06-03 $         $Revision: $
#
# ------------------------------------------------------------------------------
if [ "$#" -lt 1 ]; then
    echo "usage: Install.sh <Wheel>"
	echo "Example: install.sh pyrunner-4.0.23.34-py2.py3-none-any.whl"
    exit 1
fi

#sudo killall -w -r python*  // Stop services instead of kill all python stuff. Kira UI uses python too
sudo systemctl is-active pyrunner.service && sudo systemctl stop pyrunner.service
sudo systemctl is-active django.service && sudo systemctl stop django.service
sudo systemctl is-active chownwdog.service && sudo systemctl stop chownwdog.service

python3 -m virtualenv  pyrunner
source pyrunner/bin/activate
python3 -m pip install -r  ~/.PyRInstall/InstEnv/requirements.txt --use-deprecated=legacy-resolver --no-index --find-links ~/.PyRInstall/InstEnv/Raspbian
python3 -m pip install --upgrade --no-cache-dir --no-index --find-links=~/.PyRInstall/InstEnv/ fwwriter
# python3 -m pip install ~/.PyRInstall/InstEnv/fwwriter-0.0.0-py3-none-any.whl --upgrade
python3 -m pip install ~/.PyRInstall/InstEnv/$1

deactivate
#sudo killall -w -r python*

